/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPPacket;
import jade.mtp.TransportAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

class HTTPClientConnection
extends Connection {
    static final String RECIPIENT_ID_FIELD = "recipient-id";
    private HttpURLConnection hc;
    private static String username;
    private static String password;
    private String url;
    private InputStream is;
    private OutputStream os;
    private boolean opened;

    public HTTPClientConnection(TransportAddress ta) {
        this.url = "http://" + ta.getHost() + ":" + ta.getPort() + "/jade";
        this.opened = false;
    }

    public int writePacket(JICPPacket pkt) throws IOException {
        if (!this.opened) {
            int ret = 0;
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (username == null) {
                        username = System.getProperty("http.username");
                        password = System.getProperty("http.password");
                        if (username == null) {
                            JTextField usrTF = new JTextField();
                            JPasswordField pwdTF = new JPasswordField();
                            Object[] message = new Object[]{"Insert username and password", usrTF, pwdTF};
                            int ret = JOptionPane.showConfirmDialog(null, message, null, 2);
                            if (ret == 0) {
                                username = usrTF.getText();
                                password = pwdTF.getText();
                            }
                        }
                    }
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
            this.hc = (HttpURLConnection)new URL(this.url).openConnection();
            this.hc.setDoOutput(true);
            this.hc.setRequestMethod("POST");
            this.hc.connect();
            this.os = this.hc.getOutputStream();
            ret = pkt.writeTo(this.os);
            this.opened = true;
            return ret;
        }
        throw new IOException("Write not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JICPPacket readPacket() throws IOException {
        if (this.opened) {
            JICPPacket jICPPacket;
            try {
                this.is = this.hc.getInputStream();
                jICPPacket = JICPPacket.readFrom(this.is);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return jICPPacket;
        }
        throw new IOException("Can't read from a closed connection");
    }

    public void close() throws IOException {
        this.opened = false;
        try {
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        try {
            this.os.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.os = null;
        try {
            this.hc.disconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.hc = null;
    }

    public String getRemoteHost() throws Exception {
        throw new Exception("Unsupported operation");
    }
}

